/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.api.credential.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import ru.foodtechlab.lib.auth.integration.core.credential.CredentialServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.credential.exceptions.CredentialNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.ChangeCredentialPasswordRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.CreateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.FindCredentialWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.UpdateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.resources.CredentialResource;

@RestController
@Component
public class CredentialController
implements CredentialResource {
    private final CredentialServiceFacade credentialServiceFacade;

    @PostMapping(value={"/api/v1/credentials/{id}/change-password"})
    public SuccessApiResponse<CredentialResponse> changePassword(@PathVariable String id, @RequestBody ChangeCredentialPasswordRequest request) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.changePassword(id, request));
    }

    @PostMapping(value={"/api/v1/credentials/{id}/blocked-status-change"})
    public SuccessApiResponse<CredentialResponse> changeStatus(@PathVariable String id) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.changeStatus(id));
    }

    @PostMapping(value={"/api/v1/credentials"}, produces={"application/json"})
    public SuccessApiResponse<CredentialResponse> create(@RequestBody CreateCredentialRequest request) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.create(request));
    }

    @GetMapping(value={"/api/v1/credentials/{id}"}, produces={"application/json"})
    public SuccessApiResponse<CredentialResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((CredentialResponse)this.credentialServiceFacade.findById(id).orElseThrow(CredentialNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/credentials/username"})
    public SuccessApiResponse<CredentialResponse> findByName(@RequestParam String name) {
        return SuccessApiResponse.of((Object)((CredentialResponse)this.credentialServiceFacade.findByName(name).orElseThrow(CredentialNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/credentials"}, produces={"application/json"})
    public SuccessApiResponse<SearchResult<CredentialResponse>> find(@ModelAttribute FindCredentialWithFiltersRequest request) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.find(request));
    }

    @PutMapping(value={"/api/v1/credentials/{id}"})
    public SuccessApiResponse<CredentialResponse> update(@PathVariable String id, @RequestBody UpdateCredentialRequest updateCredentialRequest) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.update(id, updateCredentialRequest));
    }

    @PostMapping(value={"/api/v1/credentials/{id}/blocked-status-change"}, produces={"application/json"})
    public SuccessApiResponse<CredentialResponse> changeBlockStatus(@PathVariable String id) {
        return SuccessApiResponse.of((Object)this.credentialServiceFacade.changeStatus(id));
    }

    @DeleteMapping(value={"/api/v1/credentials/{id}"}, produces={"application/json"})
    public OkApiResponse delete(@PathVariable String id) {
        this.credentialServiceFacade.delete(id);
        return OkApiResponse.of();
    }

    @GetMapping(value={"/api/v1/credentials/email"}, produces={"application/json"})
    public SuccessApiResponse<CredentialResponse> findByEmail(@RequestParam String email) {
        return SuccessApiResponse.of((Object)((CredentialResponse)this.credentialServiceFacade.findByEmail(email).orElseThrow(CredentialNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/credentials/phone_number"}, produces={"application/json"})
    public SuccessApiResponse<CredentialResponse> findByPhoneNumber(@RequestParam String phone) {
        return SuccessApiResponse.of((Object)((CredentialResponse)this.credentialServiceFacade.findByPhoneNumber(phone).orElseThrow(CredentialNotFoundException::new)));
    }

    public CredentialController(CredentialServiceFacade credentialServiceFacade) {
        this.credentialServiceFacade = credentialServiceFacade;
    }
}

