package ru.foodtechlab.lib.auth.service.api.credential.v1.controllers;

import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import ru.foodtechlab.lib.auth.integration.core.credential.CredentialServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.credential.resources.InitCredentialResource;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.InitCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.routers.CredentialRoutes;

@RestController
@RequiredArgsConstructor
@Component
public class InitCredentialController implements InitCredentialResource {

    private final CredentialServiceFacade credentialServiceFacade;

    @Override
    @PostMapping(value = CredentialRoutes.INIT)
    public SuccessApiResponse<CredentialResponse> init(@RequestBody InitCredentialRequest request) {
        return SuccessApiResponse.of(credentialServiceFacade.init(request));
    }

    @Override
    @GetMapping(value = CredentialRoutes.CHECK_INIT_AVAILABLE)
    public SuccessApiResponse<Boolean> checkInitAvailable() {
        return SuccessApiResponse.of(credentialServiceFacade.checkInitAvailable());
    }
}
