/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.common.mongo.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.port.impl.AbstractMongoRepository;
import com.rcore.database.mongo.commons.query.FindByIdQuery;
import io.foodtechlab.common.domain.entities.BaseDeleteEntity;
import io.foodtechlab.common.domain.port.SafeDeleteCRUDRepository;
import io.foodtechlab.common.domain.port.filters.DeleteFilter;
import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import io.foodtechlab.common.mongo.query.FindNotDeleteByIdQuery;
import io.foodtechlab.common.mongo.update.SetDeletedUpdate;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class AbstractMongoSafeDeleteRepository<ID, E extends BaseDeleteEntity<ID>, D extends BaseDeleteDocument, F extends DeleteFilter>
extends AbstractMongoRepository<ID, E, D, F>
implements SafeDeleteCRUDRepository<ID, E, F> {
    public AbstractMongoSafeDeleteRepository(Class<D> documentClass, ExampleDataMapper<E, D> mapper, MongoTemplate mongoTemplate) {
        super(documentClass, mapper, mongoTemplate);
    }

    public Optional<E> findById(ID id) {
        return Optional.ofNullable((BaseDeleteDocument)((Object)this.mongoTemplate.findOne(FindNotDeleteByIdQuery.of(id).getQuery(), this.documentClass))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    public Optional<E> forceFindById(ID id) {
        return super.findById(id);
    }

    public boolean restore(ID id) {
        return this.mongoTemplate.update(this.documentClass).matching(FindByIdQuery.of(id).getQuery()).apply((UpdateDefinition)SetDeletedUpdate.of(false).getUpdate()).first().getModifiedCount() > 0L;
    }

    public Boolean delete(ID id) {
        return this.mongoTemplate.update(this.documentClass).matching(FindNotDeleteByIdQuery.of(id).getQuery()).apply((UpdateDefinition)SetDeletedUpdate.of(true).getUpdate()).first().getModifiedCount() > 0L;
    }

    public boolean permanentDelete(ID id) {
        return super.delete(id);
    }
}

