/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.common.mongo.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.mongodb.core.query.Criteria;

public class DateTimeObjectCriteria {
    public static WithField withField(String field) {
        return new WithField(field);
    }

    public static class WithField {
        private final String field;

        private WithField(String field) {
            this.field = field;
        }

        private static List<Criteria> dateList(String field, LocalDate from, LocalDate to) {
            ArrayList<Criteria> criteria = new ArrayList<Criteria>(3);
            criteria.add(Criteria.where((String)(field + ".year")).gte((Object)from.getYear()).lte((Object)to.getYear()));
            criteria.add(Criteria.where((String)(field + ".month")).gte((Object)from.getMonthValue()).lte((Object)to.getMonthValue()));
            criteria.add(Criteria.where((String)(field + ".day")).gte((Object)from.getDayOfMonth()).lte((Object)to.getDayOfMonth()));
            return criteria;
        }

        private static List<Criteria> timeList(String field, LocalTime from, LocalTime to) {
            ArrayList<Criteria> criteria = new ArrayList<Criteria>(3);
            criteria.add(Criteria.where((String)(field + ".hour")).gte((Object)from.getHour()).lte((Object)to.getHour()));
            criteria.add(Criteria.where((String)(field + ".minute")).gte((Object)from.getMinute()).lte((Object)to.getMinute()));
            criteria.add(Criteria.where((String)(field + ".second")).gte((Object)from.getSecond()).lte((Object)to.getSecond()));
            return criteria;
        }

        @Deprecated
        public Optional<Criteria> range(LocalDateTime from, LocalDateTime to) {
            if (from == null || to == null) {
                return Optional.empty();
            }
            ArrayList<Criteria> criteria = new ArrayList<Criteria>(7);
            criteria.addAll(WithField.dateList(this.field, from.toLocalDate(), to.toLocalDate()));
            criteria.addAll(WithField.timeList(this.field, from.toLocalTime(), to.toLocalTime()));
            return Optional.of(new Criteria().andOperator((Criteria[])criteria.toArray(Criteria[]::new)));
        }

        @Deprecated
        public Optional<Criteria> range(LocalTime from, LocalTime to) {
            if (from == null || to == null) {
                return Optional.empty();
            }
            return Optional.of(new Criteria().andOperator((Criteria[])WithField.timeList(this.field, from, to).toArray(Criteria[]::new)));
        }

        @Deprecated
        public Optional<Criteria> range(LocalDate from, LocalDate to) {
            if (from == null || to == null) {
                return Optional.empty();
            }
            return Optional.of(new Criteria().andOperator((Criteria[])WithField.dateList(this.field, from, to).toArray(Criteria[]::new)));
        }
    }
}

