/*
 * Decompiled with CFR 0.152.
 */
package io.foodtechlab.common.mongo.documents;

import com.rcore.commons.utils.StringUtils;
import io.foodtechlab.common.core.entities.FullName;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.mongodb.core.index.Indexed;

public class FullNameDoc {
    private String firstName;
    private String middleName;
    private String lastName;
    @Indexed
    private String fullName;

    public FullNameDoc(String firstName, String middleName, String lastName) {
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.fullName = this.toString();
    }

    public static FullNameDoc empty() {
        return new FullNameDoc("", "", "");
    }

    public static FullNameDoc of(FullName fullName) {
        return new FullNameDoc(fullName.getFirstName(), fullName.getMiddleName(), fullName.getLastName());
    }

    public FullName toDomain() {
        return new FullName(this.firstName, this.middleName, this.lastName);
    }

    public String toString() {
        return Stream.of(this.lastName, this.firstName, this.middleName).filter(StringUtils::hasText).collect(Collectors.joining(" "));
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public FullNameDoc() {
    }
}

