/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.api.authorization.session.v1;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import ru.foodtechlab.lib.auth.integration.core.authorizationSession.AuthorizationSessionServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.auth.exceptions.AuthorizationSessionNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByDeviceIdRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByIpRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByPhoneRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByUsernameRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.SearchAuthorizationSessionsWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.resources.AuthSessionResource;

@RestController
@Component
public class AuthSessionController
implements AuthSessionResource {
    private final AuthorizationSessionServiceFacade authorizationSessionServiceFacade;

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-device-id"}, produces={"application/json"})
    public OkApiResponse disableByDeviceId(@RequestBody DisableByDeviceIdRequest request) {
        this.authorizationSessionServiceFacade.disableByDeviceId(request);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-email"}, produces={"application/json"})
    public OkApiResponse disableByEmail(@RequestBody DisableByEmailRequest request) {
        this.authorizationSessionServiceFacade.disableByEmail(request);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/auth-sessions/{id}/disable"}, produces={"application/json"})
    public OkApiResponse disableById(@PathVariable String id) {
        this.authorizationSessionServiceFacade.disable(id);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-ipv4"}, produces={"application/json"})
    public OkApiResponse disableByIp(@RequestBody DisableByIpRequest request) {
        this.authorizationSessionServiceFacade.disableByIp(request);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-phone"}, produces={"application/json"})
    public OkApiResponse disableByPhoneNumber(@RequestBody DisableByPhoneRequest request) {
        this.authorizationSessionServiceFacade.disableByPhone(request);
        return OkApiResponse.of();
    }

    @GetMapping(value={"/api/v1/auth-sessions/{id}"}, produces={"application/json"})
    public SuccessApiResponse<AuthorizationSessionResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((AuthorizationSessionResponse)this.authorizationSessionServiceFacade.findById(id).orElseThrow(AuthorizationSessionNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/auth-sessions"}, produces={"application/json"})
    public SuccessApiResponse<SearchApiResponse<AuthorizationSessionResponse>> find(@ModelAttribute SearchAuthorizationSessionsWithFiltersRequest request) {
        SearchResult result = this.authorizationSessionServiceFacade.find(request);
        return SuccessApiResponse.of((Object)SearchApiResponse.withItemsAndCount((List)result.getItems(), (Long)result.getCount()));
    }

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-username"}, produces={"application/json"})
    public OkApiResponse disableByUsername(DisableByUsernameRequest request) {
        this.authorizationSessionServiceFacade.disableByUsername(request);
        return OkApiResponse.of();
    }

    public AuthSessionController(AuthorizationSessionServiceFacade authorizationSessionServiceFacade) {
        this.authorizationSessionServiceFacade = authorizationSessionServiceFacade;
    }
}

