package ru.foodtechlab.lib.auth.service.api.authorization.session.v1;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.integration.core.authorizationSession.AuthorizationSessionServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.auth.exceptions.AuthorizationSessionNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.resources.AuthSessionResource;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.routers.AuthSessionRoutes;

@RestController
@RequiredArgsConstructor
@Component
public class AuthSessionController implements AuthSessionResource {

    private final AuthorizationSessionServiceFacade authorizationSessionServiceFacade;

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_DEVICE_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableByDeviceId(@RequestBody DisableByDeviceIdRequest request) {
        authorizationSessionServiceFacade.disableByDeviceId(request);
        return OkApiResponse.of();
    }

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_EMAIL, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableByEmail(@RequestBody DisableByEmailRequest request) {
        authorizationSessionServiceFacade.disableByEmail(request);
        return OkApiResponse.of();
    }

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableById(@PathVariable String id) {
        authorizationSessionServiceFacade.disable(id);
        return OkApiResponse.of();
    }

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_IP, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableByIp(@RequestBody DisableByIpRequest request) {
        authorizationSessionServiceFacade.disableByIp(request);
        return OkApiResponse.of();
    }

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_PHONE, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableByPhoneNumber(@RequestBody DisableByPhoneRequest request) {
        authorizationSessionServiceFacade.disableByPhone(request);
        return OkApiResponse.of();
    }

    @Override
    @GetMapping(value = AuthSessionRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<AuthorizationSessionResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of(authorizationSessionServiceFacade.findById(id)
                .orElseThrow(AuthorizationSessionNotFoundException::new));
    }

    @Override
    @GetMapping(value = AuthSessionRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<SearchApiResponse<AuthorizationSessionResponse>> find(@ModelAttribute SearchAuthorizationSessionsWithFiltersRequest request) {
        var result = authorizationSessionServiceFacade.find(request);
        return SuccessApiResponse.of(SearchApiResponse.withItemsAndCount(result.getItems(), result.getCount()));
    }

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_USERNAME, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse disableByUsername(DisableByUsernameRequest request) {
        authorizationSessionServiceFacade.disableByUsername(request);
        return OkApiResponse.of();
    }

}
