/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import java.util.Optional;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.AccessTokenServiceFacade;
import ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken.FeignAccessTokenServiceClient;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;

@Component
public class FeignHTTPAccessTokenFacade
implements AccessTokenServiceFacade {
    private final FeignAccessTokenServiceClient httpClient;

    public SearchResult<AccessTokenResponse> find(AccessTokenFiltersRequest request) {
        return (SearchResult)this.httpClient.find(request).getResult();
    }

    public Optional<AccessTokenResponse> findById(String id) {
        return Optional.ofNullable((AccessTokenResponse)this.httpClient.findById(id).getResult());
    }

    public AccessTokenResponse decode(DecodeTokenRequest request) {
        return (AccessTokenResponse)this.httpClient.decodeJwt(request).getResult();
    }

    public EncodedTokenResponse encode(String id) {
        return (EncodedTokenResponse)this.httpClient.encodeToJwt(id).getResult();
    }

    public void expireByStatus(String id) {
        this.httpClient.expireByStatus(id);
    }

    public void deactivateByCredentialId(String credentialId) {
        this.httpClient.deactivateByCredential(new DeactivateByCredentialRequest(credentialId));
    }

    public void expireByTime(String id) {
        this.httpClient.expireByTime(id);
    }

    public FeignHTTPAccessTokenFacade(FeignAccessTokenServiceClient httpClient) {
        this.httpClient = httpClient;
    }
}

