/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken.FeignAccessTokenServiceConfig;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.resources.AccessTokenResource;

@FeignClient(name="feign-auth-service-access-token", url="${foodtechlab.infrastructure.microservice.auth-service.url}", configuration={FeignAccessTokenServiceConfig.class})
public interface FeignAccessTokenServiceClient
extends AccessTokenResource {
    @GetMapping(value={"/api/v1/access-tokens"})
    public SuccessApiResponse<SearchResult<AccessTokenResponse>> find(@SpringQueryMap AccessTokenFiltersRequest var1);

    @GetMapping(value={"/api/v1/access-tokens/{id}"})
    public SuccessApiResponse<AccessTokenResponse> findById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/access-tokens/{id}/jwt/encode"})
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/access-tokens/jwt/decode"})
    public SuccessApiResponse<AccessTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest var1);

    @PostMapping(value={"/api/v1/access-tokens/{id}/expired-by-status"})
    public OkApiResponse expireByStatus(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/access-tokens/deactivate-by-credential"})
    public OkApiResponse deactivateByCredential(@RequestBody DeactivateByCredentialRequest var1);

    @PostMapping(value={"/api/v1/access-tokens/{id}/expired-by-time"})
    public OkApiResponse expireByTime(@PathVariable(value="id") String var1);
}

