/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import java.util.Optional;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.RefreshTokenServiceFacade;
import ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken.FeignRefreshTokenServiceClient;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;

@Component
public class FeignHTTPRefreshTokenFacade
implements RefreshTokenServiceFacade {
    private final FeignRefreshTokenServiceClient httpClient;

    public SearchResult<RefreshTokenResponse> find(RefreshTokenFiltersRequest request) {
        return (SearchResult)this.httpClient.find(request).getResult();
    }

    public Optional<RefreshTokenResponse> findById(String id) {
        return Optional.ofNullable((RefreshTokenResponse)this.httpClient.findById(id).getResult());
    }

    public RefreshTokenResponse decode(DecodeTokenRequest request) {
        return (RefreshTokenResponse)this.httpClient.decodeJwt(request).getResult();
    }

    public EncodedTokenResponse encode(String id) {
        return (EncodedTokenResponse)this.httpClient.encodeToJwt(id).getResult();
    }

    public void expireByStatus(String id) {
        this.httpClient.expireByStatus(id);
    }

    public void expireByTime(String id) {
        this.httpClient.expireByTime(id);
    }

    public FeignHTTPRefreshTokenFacade(FeignRefreshTokenServiceClient httpClient) {
        this.httpClient = httpClient;
    }
}

