/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken.FeignRefreshTokenServiceConfig;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.resources.RefreshTokenResource;

@FeignClient(name="feign-auth-service-refresh-token", url="${foodtechlab.infrastructure.microservice.auth-service.url}", configuration={FeignRefreshTokenServiceConfig.class})
public interface FeignRefreshTokenServiceClient
extends RefreshTokenResource {
    @GetMapping(value={"/api/v1/refresh-tokens"})
    public SuccessApiResponse<SearchResult<RefreshTokenResponse>> find(@SpringQueryMap RefreshTokenFiltersRequest var1);

    @GetMapping(value={"/api/v1/refresh-tokens/{id}"})
    public SuccessApiResponse<RefreshTokenResponse> findById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/jwt/encode"})
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/refresh-tokens/jwt/decode"})
    public SuccessApiResponse<RefreshTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest var1);

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/expired-by-status"})
    public OkApiResponse expireByStatus(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/expired-by-time"})
    public OkApiResponse expireByTime(@PathVariable(value="id") String var1);
}

