package ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.RefreshTokenServiceFacade;
import ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken.FeignRefreshTokenServiceClient;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class FeignHTTPRefreshTokenFacade implements RefreshTokenServiceFacade {

    private final FeignRefreshTokenServiceClient httpClient;

    @Override
    public SearchResult<RefreshTokenResponse> find(RefreshTokenFiltersRequest request) {
        return httpClient.find(request).getResult();
    }

    @Override
    public Optional<RefreshTokenResponse> findById(String id) {
        return Optional.ofNullable(httpClient.findById(id).getResult());
    }

    @Override
    public RefreshTokenResponse decode(DecodeTokenRequest request) {
        return httpClient.decodeJwt(request).getResult();
    }

    @Override
    public EncodedTokenResponse encode(String id) {
        return httpClient.encodeToJwt(id).getResult();
    }

    @Override
    public void expireByStatus(String id) {
        httpClient.expireByStatus(id);
    }

    @Override
    public void expireByTime(String id) {
        httpClient.expireByTime(id);
    }
}
