package ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.exception.RefreshTokenNotFoundException;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.exception.RefreshTokenServiceException;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignRefreshTokenServiceErrorDecoder extends AuthorizationErrorDecoder {

    public FeignRefreshTokenServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        if (errorApiResponse.getErrors().size() > 0) {
            String detail = errorApiResponse.getErrors().get(0).getDetails().toLowerCase();

            if (detail.contains("not found"))
                return new RefreshTokenNotFoundException(errorApiResponse);
        }
        return new RefreshTokenServiceException(errorApiResponse);
    }
}
