package ru.foodtechlab.lib.auth.interation.restapi.feign.refreshToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.resources.RefreshTokenResource;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.routers.RefreshTokenRoutes;

@FeignClient(name = "feign-auth-service-refresh-token", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignRefreshTokenServiceConfig.class)
public interface FeignRefreshTokenServiceClient extends RefreshTokenResource {
    @Override
    @GetMapping(value = RefreshTokenRoutes.ROOT)
    SuccessApiResponse<SearchResult<RefreshTokenResponse>> find(@SpringQueryMap RefreshTokenFiltersRequest request);

    @Override
    @GetMapping(value = RefreshTokenRoutes.BY_ID)
    SuccessApiResponse<RefreshTokenResponse> findById(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = RefreshTokenRoutes.JWT_ENCODE)
    SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = RefreshTokenRoutes.JWT_DECODE)
    SuccessApiResponse<RefreshTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request);

    @Override
    @PostMapping(value = RefreshTokenRoutes.EXPIRED_BY_STATUS)
    OkApiResponse expireByStatus(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = RefreshTokenRoutes.EXPIRED_BY_TIME)
    OkApiResponse expireByTime(@PathVariable("id") String id);


}

