package ru.foodtechlab.lib.auth.interation.restapi.feign.accessToken;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.resources.AccessTokenResource;
import ru.foodtechlab.lib.auth.service.facade.accessToken.routers.AccessTokenRoutes;

@FeignClient(name = "feign-auth-service-access-token", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignAccessTokenServiceConfig.class)
public interface FeignAccessTokenServiceClient extends AccessTokenResource {

    @Override
    @GetMapping(value = AccessTokenRoutes.ROOT)
    SuccessApiResponse<SearchResult<AccessTokenResponse>> find(@SpringQueryMap AccessTokenFiltersRequest request);

    @Override
    @GetMapping(value = AccessTokenRoutes.BY_ID)
    SuccessApiResponse<AccessTokenResponse> findById(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = AccessTokenRoutes.JWT_ENCODE)
    SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = AccessTokenRoutes.JWT_DECODE)
    SuccessApiResponse<AccessTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request);

    @Override
    @PostMapping(value = AccessTokenRoutes.EXPIRED_BY_STATUS)
    OkApiResponse expireByStatus(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = AccessTokenRoutes.DEACTIVATE_BY_CRED)
    OkApiResponse deactivateByCredential(@RequestBody DeactivateByCredentialRequest request);

    @Override
    @PostMapping(value = AccessTokenRoutes.EXPIRED_BY_TIME)
    OkApiResponse expireByTime(@PathVariable(value = "id") String id);

}

