package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.RoleAccessServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.role.access.FeignRoleAccessServiceClient;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CreateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.FindRoleAccessWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.UpdateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class FeignHTTPRoleAccessFacade implements RoleAccessServiceFacade {

    private final FeignRoleAccessServiceClient httpClient;

    @Override
    public RoleAccessResponse generateGodMode() {
        return null;
    }

    @Override
    public SearchResult<RoleAccessResponse> find(FindRoleAccessWithFiltersRequest command) {
        var result = httpClient.find(command);
        return SearchResult.withItemsAndCount(
                result.getResult().getItems(),
                result.getResult().getCount()
        );
    }

    @Override
    public Optional<RoleAccessResponse> findById(String id) {
        return Optional.of(httpClient.findById(id).getResult());
    }

    @Override
    public RoleAccessResponse create(CreateRoleAccessRequest command) {
        return httpClient.create(command).getResult();
    }

    @Override
    public RoleAccessResponse update(String id, UpdateRoleAccessRequest command) {
        return httpClient.update(id, command).getResult();
    }

    @Override
    public void delete(String id) {
        httpClient.delete(id);
    }
}
