package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.role.exception.RoleNotFoundException;
import ru.foodtechlab.lib.auth.integration.core.role.exception.RoleServiceException;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.exception.RoleAccessServiceException;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignRoleAccessServiceErrorDecoder extends AuthorizationErrorDecoder {

    public FeignRoleAccessServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        return new RoleAccessServiceException(errorApiResponse);
    }
}
