package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;

import java.io.Reader;
import java.nio.charset.StandardCharsets;

@Slf4j
@RequiredArgsConstructor
public class FeignCheckAccessServiceErrorDecoder implements ErrorDecoder {

    private final ObjectMapper mapper;

    @SneakyThrows
    @Override
    public Exception decode(String s, Response response) {
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString(reader);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse<Error> errorApiResponse = mapper.readValue(result, new TypeReference<>() {});
        response.close();
        reader.close();

        return new AuthServiceException(errorApiResponse);
    }
}
