package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access;

import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import ru.foodtechlab.lib.auth.service.facade.authorization.routers.AuthorizationRoutes;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.routers.AuthSessionRoutes;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.security.resources.SecurityResource;
import ru.foodtechlab.lib.auth.service.facade.security.routers.SecurityRoutes;

@FeignClient(name = "feign-auth-service-check-access", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignCheckAccessServiceConfig.class)
public interface FeignCheckAccessServiceClient extends SecurityResource {

    @Override
    @PostMapping(value = SecurityRoutes.CHECK_ACCESS)
    SuccessApiResponse<CredentialDetails> checkAccess(@RequestBody CheckAccessByTokenRequest request);

    @Override
    @PostMapping(value = SecurityRoutes.CHECK_TOKEN)
    OkApiResponse checkToken(@RequestParam("token") String token);

    @Override
    @GetMapping(value = SecurityRoutes.CURRENT_USER)
    SuccessApiResponse<CredentialDetails> getCurrentUserByToken(String token);


}
