package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access;

import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CreateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.FindRoleAccessWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.UpdateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.resources.RoleAccessResource;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.routers.RoleAccessRoutes;
import ru.foodtechlab.lib.auth.service.facade.security.routers.SecurityRoutes;

@FeignClient(name = "feign-auth-service-role-access", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignRoleAccessServiceConfig.class)
public interface FeignRoleAccessServiceClient extends RoleAccessResource {

    @Override
    @GetMapping(value = RoleAccessRoutes.ROOT)
    SuccessApiResponse<SearchApiResponse<RoleAccessResponse>> find(@SpringQueryMap FindRoleAccessWithFiltersRequest request);

    @Override
    @GetMapping(value = RoleAccessRoutes.BY_ID)
    SuccessApiResponse<RoleAccessResponse> findById(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = RoleAccessRoutes.ROOT)
    SuccessApiResponse<RoleAccessResponse> create(@RequestBody CreateRoleAccessRequest request);

    @Override
    @PutMapping(value = RoleAccessRoutes.BY_ID)
    SuccessApiResponse<RoleAccessResponse> update(@PathVariable(value = "id") String id, @RequestBody UpdateRoleAccessRequest request);

    @Override
    @DeleteMapping(value = RoleAccessRoutes.BY_ID)
    OkApiResponse delete(@PathVariable(value = "id") String id);

}
