package ru.foodtechlab.lib.auth.integration.restapi.feign.role.access.impl;

import com.rcore.domain.security.model.CredentialDetails;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.CheckAccessServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.role.access.FeignCheckAccessServiceClient;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;

@RequiredArgsConstructor
@Component
public class FeignHTTPCheckAccessFacade implements CheckAccessServiceFacade {

    private final FeignCheckAccessServiceClient httpClient;

    @Override
    public CredentialDetails checkAccess(CheckAccessByTokenRequest command) {
        return httpClient.checkAccess(command).getResult();
    }

    @Override
    public Boolean tokenIsValid(String token) {
        httpClient.checkToken(token);
        return true;
    }
}
