package ru.foodtechlab.lib.auth.integration.feign.preference.impl;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.preference.ServicePreferenceFacade;
import ru.foodtechlab.lib.auth.integration.feign.preference.FeignServicePreferenceClient;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.requests.UpdateServicePreferenceRequest;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.responses.ServicePreferenceResponse;

@RequiredArgsConstructor
@Component
public class FeignHTTPServicePreferenceFacade implements ServicePreferenceFacade {

    private final FeignServicePreferenceClient httpClient;

    @Override
    public ServicePreferenceResponse get() {
        return httpClient.get().getResult();
    }

    @Override
    public ServicePreferenceResponse update(UpdateServicePreferenceRequest command) {
        return  httpClient.update(command).getResult();
    }
}
