package ru.foodtechlab.lib.auth.integration.feign.preference;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.preference.exception.ServicePreferenceServiceException;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.exception.RoleAccessServiceException;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignServicePreferencesErrorDecoder extends AuthorizationErrorDecoder {

    public FeignServicePreferencesErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        return new ServicePreferenceServiceException(errorApiResponse);
    }
}
