package ru.foodtechlab.lib.auth.integration.feign.preference;

import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.requests.UpdateServicePreferenceRequest;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.responses.ServicePreferenceResponse;
import ru.foodtechlab.lib.auth.service.facade.preference.resources.ServicePreferencesResource;
import ru.foodtechlab.lib.auth.service.facade.preference.routers.GetPreferenceRoutes;

@FeignClient(name = "feign-auth-service-preferences", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignServicePreferencesConfig.class)
public interface FeignServicePreferenceClient extends ServicePreferencesResource {

    @Override
    @GetMapping(value = GetPreferenceRoutes.ROOT)
    SuccessApiResponse<ServicePreferenceResponse> get();

    @Override
    @PutMapping(value = GetPreferenceRoutes.ROOT)
    SuccessApiResponse<ServicePreferenceResponse> update(@RequestBody UpdateServicePreferenceRequest request);

}
