package ru.foodtechlab.lib.auth.integration.restapi.feign.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.*;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignCredentialServiceErrorDecoder extends AuthorizationErrorDecoder {

    public FeignCredentialServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        if (errorApiResponse.getErrors().size() > 0) {
            String detail = errorApiResponse.getErrors().get(0).getDetails().toLowerCase();

            if (detail.contains("invalid old credential password"))
                return new InvalidOldCredentialPasswordException(errorApiResponse);

            if (detail.contains("credential with username already exist"))
                return new CredentialWithUsernameAlreadyExistException(errorApiResponse);

            if (detail.contains("credential with phone already exist"))
                return new CredentialWithPhoneAlreadyExistException(errorApiResponse);

            if (detail.contains("status is required"))
                return new CredentialStatusIsRequiredException(errorApiResponse);

            if (detail.contains("credential with email already exist"))
                return new CredentialWithEmailAlreadyExistException(errorApiResponse);

            if (detail.contains("not found"))
                return new CredentialNotFoundException(errorApiResponse);

            if (detail.contains("email id required"))
                return new CredentialEmailIsRequiredException(errorApiResponse);

            if (detail.contains("credential is blocked"))
                return new CredentialIsBlockedException(errorApiResponse);

            if (detail.contains("password is required"))
                return new CredentialPasswordIsRequiredException(errorApiResponse);

            if (detail.contains("phone is required"))
                return new CredentialPhoneIsRequiredException(errorApiResponse);

            if (detail.contains("role is required"))
                return new CredentialRoleIsRequiredException(errorApiResponse);
        }
        return new CredentialServiceException(errorApiResponse);
    }
}
