/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.credential.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import java.util.Optional;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.credential.CredentialServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.credential.FeignCredentialAndInitServiceClient;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.ChangeCredentialPasswordRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.CreateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.FindCredentialWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.InitCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.UpdateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

@Component
public class FeignHTTPCredentialFacade
implements CredentialServiceFacade {
    private final FeignCredentialAndInitServiceClient httpClient;

    public CredentialResponse generateDefaultCredential(String password) {
        return null;
    }

    public CredentialResponse init(InitCredentialRequest createCredentialRequest) {
        return (CredentialResponse)this.httpClient.init(createCredentialRequest).getResult();
    }

    public Boolean checkInitAvailable() {
        return (Boolean)this.httpClient.checkInitAvailable().getResult();
    }

    public SearchResult<CredentialResponse> find(FindCredentialWithFiltersRequest request) {
        return (SearchResult)this.httpClient.find(request).getResult();
    }

    public Optional<CredentialResponse> findByPhoneNumber(String phoneNumber) {
        return Optional.of((CredentialResponse)this.httpClient.findByPhoneNumber(phoneNumber).getResult());
    }

    public Optional<CredentialResponse> findByEmail(String email) {
        return Optional.of((CredentialResponse)this.httpClient.findByEmail(email).getResult());
    }

    public Optional<CredentialResponse> findById(String id) {
        return Optional.of((CredentialResponse)this.httpClient.findById(id).getResult());
    }

    public Optional<CredentialResponse> findByName(String name) {
        return Optional.of((CredentialResponse)this.httpClient.findByName(name).getResult());
    }

    public CredentialResponse create(CreateCredentialRequest createCredentialRequest) {
        return (CredentialResponse)this.httpClient.create(createCredentialRequest).getResult();
    }

    public CredentialResponse update(String id, UpdateCredentialRequest updateCredentialRequest) {
        return (CredentialResponse)this.httpClient.update(id, updateCredentialRequest).getResult();
    }

    public CredentialResponse changeStatus(String id) {
        return (CredentialResponse)this.httpClient.changeStatus(id).getResult();
    }

    public CredentialResponse changePassword(String id, ChangeCredentialPasswordRequest request) {
        return (CredentialResponse)this.httpClient.changePassword(id, request).getResult();
    }

    public void delete(String id) {
        this.httpClient.delete(id);
    }

    public FeignHTTPCredentialFacade(FeignCredentialAndInitServiceClient httpClient) {
        this.httpClient = httpClient;
    }
}

