/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialEmailIsRequiredException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialIsBlockedException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialNotFoundException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialPasswordIsRequiredException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialPhoneIsRequiredException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialRoleIsRequiredException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialServiceException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialStatusIsRequiredException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialWithEmailAlreadyExistException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialWithPhoneAlreadyExistException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.CredentialWithUsernameAlreadyExistException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.InvalidOldCredentialPasswordException;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

public class FeignCredentialServiceErrorDecoder
extends AuthorizationErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignCredentialServiceErrorDecoder.class);

    public FeignCredentialServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        if (errorApiResponse.getErrors().size() > 0) {
            String detail = ((Error)errorApiResponse.getErrors().get(0)).getDetails().toLowerCase();
            if (detail.contains("invalid old credential password")) {
                return new InvalidOldCredentialPasswordException(errorApiResponse);
            }
            if (detail.contains("credential with username already exist")) {
                return new CredentialWithUsernameAlreadyExistException(errorApiResponse);
            }
            if (detail.contains("credential with phone already exist")) {
                return new CredentialWithPhoneAlreadyExistException(errorApiResponse);
            }
            if (detail.contains("status is required")) {
                return new CredentialStatusIsRequiredException(errorApiResponse);
            }
            if (detail.contains("credential with email already exist")) {
                return new CredentialWithEmailAlreadyExistException(errorApiResponse);
            }
            if (detail.contains("not found")) {
                return new CredentialNotFoundException(errorApiResponse);
            }
            if (detail.contains("email id required")) {
                return new CredentialEmailIsRequiredException(errorApiResponse);
            }
            if (detail.contains("credential is blocked")) {
                return new CredentialIsBlockedException(errorApiResponse);
            }
            if (detail.contains("password is required")) {
                return new CredentialPasswordIsRequiredException(errorApiResponse);
            }
            if (detail.contains("phone is required")) {
                return new CredentialPhoneIsRequiredException(errorApiResponse);
            }
            if (detail.contains("role is required")) {
                return new CredentialRoleIsRequiredException(errorApiResponse);
            }
        }
        return new CredentialServiceException(errorApiResponse);
    }
}

