/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.credential;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import ru.foodtechlab.lib.auth.integration.restapi.feign.credential.FeignCredentialServiceConfig;
import ru.foodtechlab.lib.auth.integration.restapi.feign.credential.UnitedResources;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.ChangeCredentialPasswordRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.CreateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.FindCredentialWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.InitCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.UpdateCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

@FeignClient(name="feign-auth-service-credential-init", url="${foodtechlab.infrastructure.microservice.auth-service.url}", configuration={FeignCredentialServiceConfig.class})
public interface FeignCredentialAndInitServiceClient
extends UnitedResources {
    @PostMapping(value={"/not-secure/api/v1/credentials"})
    public SuccessApiResponse<CredentialResponse> init(@RequestBody InitCredentialRequest var1);

    @PostMapping(value={"/api/v1/credentials"})
    public SuccessApiResponse<CredentialResponse> create(@RequestBody CreateCredentialRequest var1);

    @GetMapping(value={"/not-secure/api/v1/credentials/check-available"})
    public SuccessApiResponse<Boolean> checkInitAvailable();

    @GetMapping(value={"/api/v1/credentials"})
    public SuccessApiResponse<SearchResult<CredentialResponse>> find(@SpringQueryMap FindCredentialWithFiltersRequest var1);

    @GetMapping(value={"/api/v1/credentials/{id}"})
    public SuccessApiResponse<CredentialResponse> findById(@PathVariable(value="id") String var1);

    @GetMapping(value={"/api/v1/credentials/username"})
    public SuccessApiResponse<CredentialResponse> findByName(@RequestParam(value="name") String var1);

    @GetMapping(value={"/api/v1/credentials/phone_number"})
    public SuccessApiResponse<CredentialResponse> findByPhoneNumber(@RequestParam(value="phone") String var1);

    @GetMapping(value={"/api/v1/credentials/email"})
    public SuccessApiResponse<CredentialResponse> findByEmail(@RequestParam(value="email") String var1);

    @PutMapping(value={"/api/v1/credentials/{id}"})
    public SuccessApiResponse<CredentialResponse> update(@PathVariable(value="id") String var1, @RequestBody UpdateCredentialRequest var2);

    @PostMapping(value={"/api/v1/credentials/{id}/blocked-status-change"})
    public SuccessApiResponse<CredentialResponse> changeStatus(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/credentials/{id}/change-password"})
    public SuccessApiResponse<CredentialResponse> changePassword(@PathVariable(value="id") String var1, @RequestBody ChangeCredentialPasswordRequest var2);

    @DeleteMapping(value={"/api/v1/credentials/{id}"})
    public OkApiResponse delete(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/credentials/{id}/blocked-status-change"})
    public SuccessApiResponse<CredentialResponse> changeBlockStatus(@PathVariable(value="id") String var1);
}

