package ru.foodtechlab.lib.auth.integration.restapi.feign.credential.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.credential.CredentialServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.credential.FeignCredentialAndInitServiceClient;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class FeignHTTPCredentialFacade implements CredentialServiceFacade {

    private final FeignCredentialAndInitServiceClient httpClient;

    @Override
    public CredentialResponse generateDefaultCredential(String password) {
        return null;
    }

    @Override
    public CredentialResponse init(InitCredentialRequest createCredentialRequest) {
        return httpClient.init(createCredentialRequest).getResult();
    }

    @Override
    public Boolean checkInitAvailable() {
        return httpClient.checkInitAvailable().getResult();
    }

    @Override
    public SearchResult<CredentialResponse> find(FindCredentialWithFiltersRequest request) {
        return httpClient.find(request).getResult();
    }

    @Override
    public Optional<CredentialResponse> findByPhoneNumber(String phoneNumber) {
        return Optional.of(httpClient.findByPhoneNumber(phoneNumber).getResult());
    }

    @Override
    public Optional<CredentialResponse> findByEmail(String email) {
        return Optional.of(httpClient.findByEmail(email).getResult());
    }

    @Override
    public Optional<CredentialResponse> findById(String id) {
        return  Optional.of(httpClient.findById(id).getResult());
    }

    @Override
    public Optional<CredentialResponse> findByName(String name) {
        return Optional.of(httpClient.findByName(name).getResult());
    }

    @Override
    public CredentialResponse create(CreateCredentialRequest createCredentialRequest) {
        return httpClient.create(createCredentialRequest).getResult();
    }

    @Override
    public CredentialResponse update(String id, UpdateCredentialRequest updateCredentialRequest) {
        return httpClient.update(id, updateCredentialRequest).getResult();
    }

    @Override
    public CredentialResponse changeStatus(String id) {
        return httpClient.changeStatus(id).getResult();
    }

    @Override
    public CredentialResponse changePassword(String id, ChangeCredentialPasswordRequest request) {
        return httpClient.changePassword(id, request).getResult();
    }

    @Override
    public void delete(String id) {
        httpClient.delete(id);
    }
}
