package ru.foodtechlab.lib.auth.integration.restapi.feign.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Logger;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import feign.okhttp.OkHttpClient;
import org.springframework.context.annotation.Bean;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationRequestInterceptor;

public class FeignCredentialServiceConfig {

    @Bean
    public OkHttpClient feignClient() {
        return new OkHttpClient();
    }

    @Bean
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public RequestInterceptor requestInterceptor(AccessTokenService accessTokenService) {
        return new AuthorizationRequestInterceptor(accessTokenService);
    }

    @Bean
    public ErrorDecoder feignErrorDecoder(ObjectMapper objectMapper, AccessTokenService tokenService) {
        return new FeignCredentialServiceErrorDecoder(objectMapper, tokenService);
    }

    @Bean
    public Retryer retryer() {
        return new Retryer.Default();
    }

}
