package ru.foodtechlab.lib.auth.integration.restapi.feign.credential;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.routers.CredentialRoutes;



@FeignClient(name = "feign-auth-service-credential-init", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignCredentialServiceConfig.class)
public interface FeignCredentialAndInitServiceClient extends UnitedResources {

    @Override
    @PostMapping(value = CredentialRoutes.INIT)
    SuccessApiResponse<CredentialResponse> init(@RequestBody InitCredentialRequest createCredentialRequest);

    @Override
    @PostMapping(value = CredentialRoutes.ROOT)
    SuccessApiResponse<CredentialResponse> create(@RequestBody CreateCredentialRequest createCredentialRequest);

    @Override
    @GetMapping(value = CredentialRoutes.CHECK_INIT_AVAILABLE)
    SuccessApiResponse<Boolean> checkInitAvailable();

    @Override
    @GetMapping(value = CredentialRoutes.ROOT)
    SuccessApiResponse<SearchResult<CredentialResponse>> find(@SpringQueryMap FindCredentialWithFiltersRequest request);

    @Override
    @GetMapping(value = CredentialRoutes.BY_ID)
    SuccessApiResponse<CredentialResponse> findById(@PathVariable(value = "id") String id);

    @Override
    @GetMapping(value = CredentialRoutes.BY_NAME)
    SuccessApiResponse<CredentialResponse> findByName(@RequestParam(value = "name") String name);

    @Override
    @GetMapping(value = CredentialRoutes.BY_PHONE_NUMBER)
    SuccessApiResponse<CredentialResponse> findByPhoneNumber(@RequestParam(value = "phone") String phone);

    @Override
    @GetMapping(value = CredentialRoutes.BY_EMAIL)
    SuccessApiResponse<CredentialResponse> findByEmail(@RequestParam(value = "email") String email);

    @Override
    @PutMapping(value = CredentialRoutes.BY_ID)
    SuccessApiResponse<CredentialResponse> update(@PathVariable(value = "id") String id, @RequestBody UpdateCredentialRequest updateCredentialRequest);

    @Override
    @PostMapping(value = CredentialRoutes.BLOCKED_CHANGE_STATUS)
    SuccessApiResponse<CredentialResponse> changeStatus(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = CredentialRoutes.CHANGE_PASSWORD)
    SuccessApiResponse<CredentialResponse> changePassword(@PathVariable(value = "id") String id, @RequestBody ChangeCredentialPasswordRequest request);

    @Override
    @DeleteMapping(value = CredentialRoutes.BY_ID)
    OkApiResponse delete(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = CredentialRoutes.BLOCKED_CHANGE_STATUS)
    SuccessApiResponse<CredentialResponse> changeBlockStatus(@PathVariable(value = "id") String id);
}
