/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.commons;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rcore.domain.security.exceptions.AuthorizationErrorReason;
import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import io.foodtechlab.exceptionhandler.core.Error;
import io.foodtechlab.exceptionhandler.core.ErrorApiResponse;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;

public class AuthorizationErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationErrorDecoder.class);
    protected final ObjectMapper mapper;
    protected final AccessTokenService accessTokenService;
    protected List<String> reasonsForRetry = Arrays.asList(AuthorizationErrorReason.ACCESS_TOKEN_EXPIRED.name(), AuthorizationErrorReason.ACCESS_TOKEN_INACTIVATED.name(), AuthorizationErrorReason.ACCESS_TOKEN_REFRESHED.name(), AuthorizationErrorReason.ACCESS_TOKEN_NOT_EXIST.name(), AuthorizationErrorReason.ACCESS_TOKEN_MODIFIED.name(), AuthorizationErrorReason.ACCESS_TOKEN_MALFORMED.name());

    public Exception decode(String s, Response response) {
        String reason;
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString((Reader)reader);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse errorResponse = (ErrorApiResponse)this.mapper.readValue(result, (TypeReference)new TypeReference<ErrorApiResponse<Error>>(){});
        response.close();
        reader.close();
        if ((response.status() == 401 || response.status() == 403) && !errorResponse.getErrors().isEmpty() && this.reasonsForRetry.contains(reason = ((Error)errorResponse.getErrors().get(0)).getReason())) {
            this.accessTokenService.clearToken(response.request().url());
            throw new RetryableException(response.status(), response.reason(), response.request().httpMethod(), null, response.request());
        }
        return this.decode((ErrorApiResponse<Error>)errorResponse);
    }

    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        return new HttpCommunicationException(errorApiResponse);
    }

    public AuthorizationErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        this.mapper = mapper;
        this.accessTokenService = accessTokenService;
    }
}

