/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.commons;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.net.URL;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;

public class AuthorizationRequestInterceptor
implements RequestInterceptor {
    private final AccessTokenService tokenService;

    public void apply(RequestTemplate requestTemplate) {
        String token = this.tokenService.getAccessToken(this.getToken(requestTemplate));
        requestTemplate.removeHeader("X-Auth-Token");
        requestTemplate.header("X-Auth-Token", new String[]{token});
    }

    private String getToken(RequestTemplate requestTemplate) {
        try {
            return new URL(requestTemplate.url()).getHost();
        }
        catch (Exception ex) {
            return requestTemplate.feignTarget().url();
        }
    }

    public AuthorizationRequestInterceptor(AccessTokenService tokenService) {
        this.tokenService = tokenService;
    }
}

