package ru.foodtechlab.lib.auth.integration.restapi.feign.commons;

import com.rcore.rest.api.commons.header.WebHeaders;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.RequiredArgsConstructor;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RequiredArgsConstructor
public class AuthorizationRequestInterceptor implements RequestInterceptor {

    private final AccessTokenService tokenService;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        var token = tokenService.getAccessToken(getToken(requestTemplate));
        requestTemplate.removeHeader(WebHeaders.X_AUTH_TOKEN);
        requestTemplate.header(WebHeaders.X_AUTH_TOKEN, token);
    }

    private String getToken(RequestTemplate requestTemplate) {
        try{
           return new URL(requestTemplate.url()).getHost();
        }catch (Exception ex){
            return requestTemplate.feignTarget().url();
        }
    }
}
