/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.impl;

import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthorizationServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.AuthServiceException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.BadCredentialsExceptions;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthorizationServiceClient;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.EmailAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.LogoutRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.PhoneNumberAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.RefreshTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpByPhoneNumberRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpConfirmationByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpConfirmationByPhoneNumberRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.UsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;

@Component
public class FeignHTTPAuthorizationServiceFacade
implements AuthorizationServiceFacade {
    private final FeignAuthorizationServiceClient httpClient;

    public BasicAuthorizationResponse usernameAuthorization(UsernameAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return (BasicAuthorizationResponse)this.httpClient.usernameAuthorization(command).getResult();
    }

    public ConfirmationCodeTimerResponse singUpByPhoneNumber(SignUpByPhoneNumberRequest command) {
        return (ConfirmationCodeTimerResponse)this.httpClient.signUpByPhoneNumber(command).getResult();
    }

    public ConfirmationCodeTimerResponse singUpByEmail(SignUpByEmailRequest command) {
        return (ConfirmationCodeTimerResponse)this.httpClient.signUpByEmail(command).getResult();
    }

    public BasicAuthorizationResponse signUpConfirmationByPhoneNumber(SignUpConfirmationByPhoneNumberRequest command) {
        return (BasicAuthorizationResponse)this.httpClient.signUpConfirmationByPhoneNumber(command).getResult();
    }

    public BasicAuthorizationResponse signUpConfirmationByEmail(SignUpConfirmationByEmailRequest command) {
        return (BasicAuthorizationResponse)this.httpClient.signUpConfirmationByEmail(command).getResult();
    }

    public BasicAuthorizationResponse phoneNumberAuthorization(PhoneNumberAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return (BasicAuthorizationResponse)this.httpClient.phoneAuthorization(command).getResult();
    }

    public BasicAuthorizationResponse emailAuthorization(EmailAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return (BasicAuthorizationResponse)this.httpClient.emailAuthorization(command).getResult();
    }

    public BasicAuthorizationResponse refreshToken(RefreshTokenRequest command) throws AuthServiceException {
        return (BasicAuthorizationResponse)this.httpClient.refreshToken(command).getResult();
    }

    public void logout(LogoutRequest command) throws AuthServiceException {
        this.httpClient.logout(command);
    }

    public FeignHTTPAuthorizationServiceFacade(FeignAuthorizationServiceClient httpClient) {
        this.httpClient = httpClient;
    }
}

