/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.okhttp.OkHttpClient;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthServiceErrorDecoder;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthorizationServiceClient;

@Service
@Import(value={FeignClientsConfiguration.class})
public class FeignAuthorizationClientFactory {
    private final ObjectMapper objectMapper;
    private final Encoder encoder;
    private final Decoder decoder;
    private final Contract contract;

    public FeignAuthorizationServiceClient create(String hostname) {
        return (FeignAuthorizationServiceClient)Feign.builder().client((Client)new OkHttpClient()).encoder(this.encoder).decoder(this.decoder).contract(this.contract).errorDecoder((ErrorDecoder)new FeignAuthServiceErrorDecoder(this.objectMapper)).target(FeignAuthorizationServiceClient.class, hostname);
    }

    public FeignAuthorizationClientFactory(ObjectMapper objectMapper, Encoder encoder, Decoder decoder, Contract contract) {
        this.objectMapper = objectMapper;
        this.encoder = encoder;
        this.decoder = decoder;
        this.contract = contract;
    }
}

