package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.impl;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthorizationServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthorizationServiceClient;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;

@RequiredArgsConstructor
@Component
public class FeignHTTPAuthorizationServiceFacade implements AuthorizationServiceFacade {

    private final FeignAuthorizationServiceClient httpClient;

    @Override
    public BasicAuthorizationResponse usernameAuthorization(UsernameAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return httpClient.usernameAuthorization(command).getResult();
    }

    @Override
    public ConfirmationCodeTimerResponse singUpByPhoneNumber(SignUpByPhoneNumberRequest command) {
        return httpClient.signUpByPhoneNumber(command).getResult();
    }

    @Override
    public ConfirmationCodeTimerResponse singUpByEmail(SignUpByEmailRequest command) {
        return httpClient.signUpByEmail(command).getResult();
    }

    @Override
    public BasicAuthorizationResponse signUpConfirmationByPhoneNumber(SignUpConfirmationByPhoneNumberRequest command) {
        return httpClient.signUpConfirmationByPhoneNumber(command).getResult();
    }

    @Override
    public BasicAuthorizationResponse signUpConfirmationByEmail(SignUpConfirmationByEmailRequest command) {
        return httpClient.signUpConfirmationByEmail(command).getResult();
    }

    @Override
    public BasicAuthorizationResponse phoneNumberAuthorization(PhoneNumberAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return httpClient.phoneAuthorization(command).getResult();
    }

    @Override
    public BasicAuthorizationResponse emailAuthorization(EmailAuthorizationRequest command) throws AuthServiceException, BadCredentialsExceptions {
        return httpClient.emailAuthorization(command).getResult();
    }

    @Override
    public BasicAuthorizationResponse refreshToken(RefreshTokenRequest command) throws AuthServiceException {
        return httpClient.refreshToken(command).getResult();
    }

    @Override
    public void logout(LogoutRequest command) throws AuthServiceException {
        httpClient.logout(command);
    }
}
