package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import feign.Headers;
import feign.RequestLine;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.resources.AuthorizationResource;
import ru.foodtechlab.lib.auth.service.facade.authorization.routers.AuthorizationRoutes;

@FeignClient(name = "feign-auth-service", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignAuthServiceConfig.class)
public interface FeignAuthorizationServiceClient extends AuthorizationResource {

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_USERNAME)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_USERNAME)
    SuccessApiResponse<BasicAuthorizationResponse> usernameAuthorization(@RequestBody UsernameAuthorizationRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.LOGIN_PASSWORD_USERNAME)
    @PostMapping(value = AuthorizationRoutes.LOGIN_PASSWORD_USERNAME)
    SuccessApiResponse<BasicAuthorizationResponse> usernameAuthorization(@RequestBody BasicUsernameAuthorizationRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_EMAIL)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_EMAIL)
    SuccessApiResponse<BasicAuthorizationResponse> emailAuthorization(@RequestBody EmailAuthorizationRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.LOGOUT)
    @PostMapping(value = AuthorizationRoutes.LOGOUT)
    OkApiResponse logout(@RequestBody LogoutRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " +  AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_EMAIL_INIT)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_EMAIL_INIT)
    SuccessApiResponse<ConfirmationCodeTimerResponse> signUpByEmail(@RequestBody SignUpByEmailRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_PHONE_INIT)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_PHONE_INIT)
    SuccessApiResponse<ConfirmationCodeTimerResponse> signUpByPhoneNumber(@RequestBody SignUpByPhoneNumberRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_EMAIL_CONFIRM)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_EMAIL_CONFIRM)
    SuccessApiResponse<BasicAuthorizationResponse> signUpConfirmationByEmail(@RequestBody SignUpConfirmationByEmailRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_PHONE_CONFIRM)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_TWO_STEPS_WITH_CONFIRMATION_PHONE_CONFIRM)
    SuccessApiResponse<BasicAuthorizationResponse> signUpConfirmationByPhoneNumber(@RequestBody SignUpConfirmationByPhoneNumberRequest request);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.LOGIN_PASSWORD_EMAIL)
    @PostMapping(value = AuthorizationRoutes.LOGIN_PASSWORD_EMAIL)
    SuccessApiResponse<BasicAuthorizationResponse> emailAuthorization(@RequestBody BasicEmailAuthorizationRequest request);


    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("GET " + AuthorizationRoutes.LOGOUT)
    @GetMapping(value = AuthorizationRoutes.LOGOUT)
    OkApiResponse logout(@RequestParam(value = "accessToken") String accessToken);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.REFRESH)
    @PostMapping(value = AuthorizationRoutes.REFRESH)
    SuccessApiResponse<BasicAuthorizationResponse> refreshToken(@RequestBody RefreshTokenRequest refreshTokenRequest);

    @Override
    @Headers("Content-Type: application/json")
    @RequestLine("POST " + AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_PHONE)
    @PostMapping(value = AuthorizationRoutes.SINGLE_FACTOR_ONE_STEP_WITH_PASSWORD_PHONE)
    SuccessApiResponse<BasicAuthorizationResponse> phoneAuthorization(@RequestBody  PhoneNumberAuthorizationRequest request);


}
