/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.AuthServiceException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.BadCredentialsExceptions;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.CredentialIsBlockedException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.CredentialNotFoundException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.InvalidTokenException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.ParsingTokenException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.TokenIsExpiredException;

public class FeignAuthServiceErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignAuthServiceErrorDecoder.class);
    private final ObjectMapper mapper;

    public Exception decode(String s, Response response) {
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString((Reader)reader);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse errorApiResponse = (ErrorApiResponse)this.mapper.readValue(result, (TypeReference)new TypeReference<ErrorApiResponse<Error>>(){});
        response.close();
        reader.close();
        if (!errorApiResponse.getErrors().isEmpty()) {
            Error exceptionDTO = (Error)errorApiResponse.getErrors().get(0);
            if (exceptionDTO == null) {
                return new CredentialNotFoundException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("ACCOUNT_IS_BLOCKED")) {
                return new CredentialIsBlockedException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("CREDENTIAL_NOT_FOUND")) {
                return new CredentialNotFoundException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("INVALID_TOKEN")) {
                return new InvalidTokenException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("INVALID_TOKEN_FORMAT")) {
                return new ParsingTokenException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("EXPIRED_TOKEN")) {
                return new TokenIsExpiredException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("BAD_CREDENTIALS")) {
                return new BadCredentialsExceptions((Object)errorApiResponse);
            }
        }
        return new AuthServiceException((Object)errorApiResponse);
    }

    public FeignAuthServiceErrorDecoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

