/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rcore.domain.security.exceptions.AccessTokenInactivatedException;
import com.rcore.domain.security.exceptions.AccessTokenMalformedException;
import com.rcore.domain.security.exceptions.AccessTokenModifiedException;
import com.rcore.domain.security.exceptions.AccessTokenNotExistException;
import com.rcore.domain.security.exceptions.AccessTokenNotProvidedException;
import com.rcore.domain.security.exceptions.AccessTokenRefreshedException;
import com.rcore.domain.security.exceptions.CredentialBlockedException;
import com.rcore.domain.security.exceptions.CredentialNotExistException;
import com.rcore.domain.security.exceptions.CredentialPermissionInsufficientException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.AuthServiceException;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.CredentialNotFoundException;

public class FeignAuthServiceCredentialErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(FeignAuthServiceCredentialErrorDecoder.class);
    private final ObjectMapper mapper;

    public Exception decode(String s, Response response) {
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString((Reader)reader);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse errorApiResponse = (ErrorApiResponse)this.mapper.readValue(result, (TypeReference)new TypeReference<ErrorApiResponse<Error>>(){});
        response.close();
        reader.close();
        if (!errorApiResponse.getErrors().isEmpty()) {
            Error exceptionDTO = (Error)errorApiResponse.getErrors().get(0);
            if (exceptionDTO == null) {
                return new CredentialNotFoundException((Object)errorApiResponse);
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_NOT_PROVIDED")) {
                return new AccessTokenNotProvidedException();
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_MALFORMED")) {
                return new AccessTokenMalformedException();
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_MODIFIED")) {
                return new AccessTokenModifiedException();
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_NOT_EXIST")) {
                return new AccessTokenNotExistException();
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_INACTIVATED")) {
                return new AccessTokenInactivatedException();
            }
            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_REFRESHED")) {
                return new AccessTokenRefreshedException();
            }
            if (exceptionDTO.getDetails().equals("CREDENTIAL_NOT_EXIST")) {
                return new CredentialNotExistException();
            }
            if (exceptionDTO.getDetails().equals("CREDENTIAL_BLOCKED")) {
                return new CredentialBlockedException();
            }
            if (exceptionDTO.getDetails().equals("CREDENTIAL_PERMISSIONS_INSUFFICIENT")) {
                return new CredentialPermissionInsufficientException();
            }
        }
        return new AuthServiceException((Object)errorApiResponse);
    }

    public FeignAuthServiceCredentialErrorDecoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

