package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import ru.foodtechlab.lib.auth.service.facade.authorization.routers.AuthorizationRoutes;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.routers.CredentialRoutes;
import ru.foodtechlab.lib.auth.service.facade.security.routers.SecurityRoutes;

@FeignClient(name = "feign-credential-service", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignAuthServiceCredentialConfig.class)
public interface FeignCredentialServiceClient {

    @GetMapping(value = SecurityRoutes.CURRENT_USER)
    SuccessApiResponse<CredentialResponse> getCredentialByToken(@RequestParam("token") String accessToken);

    @GetMapping(value = CredentialRoutes.BY_ID)
    SuccessApiResponse<CredentialResponse> findCredentialById(@PathVariable("id") String id);
}
