package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.codec.ErrorDecoder;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;

import java.io.Reader;
import java.nio.charset.StandardCharsets;

@Slf4j
@RequiredArgsConstructor
public class FeignAuthServiceErrorDecoder implements ErrorDecoder {

    private final ObjectMapper mapper;

    @SneakyThrows
    @Override
    public Exception decode(String s, Response response) {
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString(reader);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse<Error> errorApiResponse = mapper.readValue(result, new TypeReference<>() {});
        response.close();
        reader.close();

        if (!errorApiResponse.getErrors().isEmpty()) {
            Error exceptionDTO = errorApiResponse.getErrors().get(0);
            if (exceptionDTO == null)
                return new CredentialNotFoundException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("ACCOUNT_IS_BLOCKED"))
                return new CredentialIsBlockedException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("CREDENTIAL_NOT_FOUND"))
                return new CredentialNotFoundException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("INVALID_TOKEN"))
                return new InvalidTokenException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("INVALID_TOKEN_FORMAT"))
                return new ParsingTokenException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("EXPIRED_TOKEN"))
                return new TokenIsExpiredException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("BAD_CREDENTIALS"))
                return new BadCredentialsExceptions(errorApiResponse);
        }
        return new AuthServiceException(errorApiResponse);

    }
}
