package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.factory;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.okhttp.OkHttpClient;
import lombok.RequiredArgsConstructor;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthServiceErrorDecoder;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthorizationServiceClient;

@RequiredArgsConstructor
@Service
@Import(FeignClientsConfiguration.class)
public class FeignAuthorizationClientFactory {

    private final ObjectMapper objectMapper;
    private final Encoder encoder;
    private final Decoder decoder;
    private final Contract contract;

    public FeignAuthorizationServiceClient create(String hostname) {
        return Feign.builder()
                .client(new OkHttpClient())
                .encoder(encoder)
                .decoder(decoder)
                .contract(contract)
                .errorDecoder(new FeignAuthServiceErrorDecoder(objectMapper))
                .target(FeignAuthorizationServiceClient.class, hostname);
    }
}
