package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rcore.domain.security.exceptions.*;
import feign.Response;
import feign.codec.ErrorDecoder;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;

import java.io.Reader;
import java.nio.charset.StandardCharsets;

@RequiredArgsConstructor
@Slf4j
public class FeignAuthServiceCredentialErrorDecoder implements ErrorDecoder {

    private final ObjectMapper mapper;

    @SneakyThrows
    @Override
    public Exception decode(String s, Response response) {
        Reader reader = response.body().asReader(StandardCharsets.UTF_8);
        String result = IOUtils.toString(reader);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ErrorApiResponse<Error> errorApiResponse = mapper.readValue(result, new TypeReference<>() {});
        response.close();
        reader.close();

        if (!errorApiResponse.getErrors().isEmpty()) {
            Error exceptionDTO = errorApiResponse.getErrors().get(0);
            if (exceptionDTO == null)
                return new CredentialNotFoundException(errorApiResponse);

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_NOT_PROVIDED"))
                return new AccessTokenNotProvidedException();

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_MALFORMED"))
                return new AccessTokenMalformedException();

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_MODIFIED"))
                return new AccessTokenModifiedException();

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_NOT_EXIST"))
                return new AccessTokenNotExistException();

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_INACTIVATED"))
                return new AccessTokenInactivatedException();

            if (exceptionDTO.getDetails().equals("ACCESS_TOKEN_REFRESHED"))
                return new AccessTokenRefreshedException();

            if (exceptionDTO.getDetails().equals("CREDENTIAL_NOT_EXIST"))
                return new CredentialNotExistException();

            if (exceptionDTO.getDetails().equals("CREDENTIAL_BLOCKED"))
                return new CredentialBlockedException();

            if (exceptionDTO.getDetails().equals("CREDENTIAL_PERMISSIONS_INSUFFICIENT"))
                return new CredentialPermissionInsufficientException();
        }
        return new AuthServiceException(errorApiResponse);
    }
}
