/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.impl;

import com.rcore.rest.api.commons.exception.HttpCommunicationException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.FoodtechlabGroupProperties;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignAuthorizationServiceClient;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.factory.FeignAuthorizationClientFactory;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.RefreshTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.UsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.TokenPairDTO;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

public class AccessTokenServiceWithGroups
implements AccessTokenService {
    private final FoodtechlabGroupProperties groups;
    private final FeignAuthorizationClientFactory httpClientFactory;
    private final Map<String, TokenPairDTO> tokens = new HashMap<String, TokenPairDTO>();
    @Value(value="${spring.application.name}")
    private String serviceName;
    private final String roleCode = "MICROSERVICE";
    private final String platform = "spring-boot-app";

    public String getAccessToken(String requestUrl) {
        FoodtechlabGroupProperties.Group group = this.findGroup(requestUrl);
        TokenPairDTO targetTokenPair = this.tokens.get(group.getName());
        if (targetTokenPair == null) {
            this.tokens.put(group.getName(), this.login(group));
        } else if (targetTokenPair.getAccessToken() == null) {
            if (targetTokenPair.getRefreshToken() != null) {
                this.tokens.put(group.getName(), this.refreshToken(group));
            } else {
                this.tokens.put(group.getName(), this.login(group));
            }
        }
        return this.tokens.get(group.getName()).getAccessToken();
    }

    public void clearToken(String requestUrl) {
        FoodtechlabGroupProperties.Group group = this.findGroup(requestUrl);
        TokenPairDTO targetTokenPair = this.tokens.get(group.getName());
        targetTokenPair.setAccessToken(null);
    }

    private TokenPairDTO login(FoodtechlabGroupProperties.Group group) {
        FeignAuthorizationServiceClient httpClient = this.httpClientFactory.create(group.getAuthService().getUrl());
        BasicAuthorizationResponse newPair = (BasicAuthorizationResponse)httpClient.usernameAuthorization(((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)((UsernameAuthorizationRequest.UsernameAuthorizationRequestBuilder)UsernameAuthorizationRequest.builder().username(group.getUsername()).password(group.getPassword()).roleCode("MICROSERVICE")).ip("127.0.0.1")).deviceId(this.serviceName)).applicationDetails(AuthorizationSessionResponse.ApplicationDetails.builder().name(this.serviceName).platform("spring-boot-app").build())).build()).getResult();
        return TokenPairDTO.of((String)newPair.getAccessToken(), (String)newPair.getRefreshToken());
    }

    private TokenPairDTO refreshToken(FoodtechlabGroupProperties.Group group) {
        try {
            TokenPairDTO targetTokenPair = this.tokens.get(group.getName());
            FeignAuthorizationServiceClient httpClient = this.httpClientFactory.create(group.getAuthService().getUrl());
            BasicAuthorizationResponse newPair = (BasicAuthorizationResponse)httpClient.refreshToken(RefreshTokenRequest.of((String)targetTokenPair.getRefreshToken())).getResult();
            return TokenPairDTO.of((String)newPair.getAccessToken(), (String)newPair.getRefreshToken());
        }
        catch (HttpCommunicationException e) {
            return this.login(group);
        }
    }

    private FoodtechlabGroupProperties.Group findGroup(String requestUrl) {
        return (FoodtechlabGroupProperties.Group)this.groups.findGroupByService(requestUrl).orElseThrow(() -> new RuntimeException("Service group not found. Please, configure your groups"));
    }

    public AccessTokenServiceWithGroups(FoodtechlabGroupProperties groups, FeignAuthorizationClientFactory httpClientFactory) {
        this.groups = groups;
        this.httpClientFactory = httpClientFactory;
    }
}

