package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.impl;


import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthCredentialServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.exception.*;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.FeignCredentialServiceClient;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

@RequiredArgsConstructor
@Component
public class FeignHTTPAuthCredentialServiceFacade implements AuthCredentialServiceFacade {

    private final FeignCredentialServiceClient httpClient;

    @Override
    public CredentialResponse getCredentialByAccessToken(String accessToken) throws AuthServiceException, CredentialNotFoundException, CredentialIsBlockedException, TokenIsExpiredException, ParsingTokenException {
        return httpClient.getCredentialByToken(accessToken).getResult();
    }
}
