package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.resources.AuthSessionResource;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.routers.AuthSessionRoutes;

@FeignClient(name = "feign-auth-session-service", url = "${foodtechlab.infrastructure.microservice.auth-service.url}", configuration = FeignAuthorizationSessionServiceErrorDecoder.class)
public interface FeignAuthorizationSessionClient extends  AuthSessionResource {

    @Override
    @GetMapping(value = AuthSessionRoutes.ROOT)
    SuccessApiResponse<SearchApiResponse<AuthorizationSessionResponse>> find(@SpringQueryMap SearchAuthorizationSessionsWithFiltersRequest request);

    @Override
    @GetMapping(value = AuthSessionRoutes.BY_ID)
    SuccessApiResponse<AuthorizationSessionResponse> findById(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_ID)
    OkApiResponse disableById(@PathVariable(value = "id") String id);

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_PHONE)
    OkApiResponse disableByPhoneNumber(@RequestBody DisableByPhoneRequest request);

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_USERNAME)
    OkApiResponse disableByUsername(@RequestBody DisableByUsernameRequest request);

    @Override
    @PostMapping(value =AuthSessionRoutes.DISABLE_BY_EMAIL)
    OkApiResponse disableByEmail(@RequestBody DisableByEmailRequest request);

    @Override
    @PostMapping(value = AuthSessionRoutes.DISABLE_BY_IP)
    OkApiResponse disableByIp(@RequestBody DisableByIpRequest request);

    @Override
    @PostMapping(value =AuthSessionRoutes.DISABLE_BY_DEVICE_ID)
    OkApiResponse disableByDeviceId(@RequestBody DisableByDeviceIdRequest request);


}
