/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.authorizationSession.AuthorizationSessionServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session.FeignAuthorizationSessionClient;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByDeviceIdRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByIpRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByPhoneRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByUsernameRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.SearchAuthorizationSessionsWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

@Component
public class FeignHTTPAuthorizationSessionFacade
implements AuthorizationSessionServiceFacade {
    private final FeignAuthorizationSessionClient httpClient;

    public SearchResult<AuthorizationSessionResponse> find(SearchAuthorizationSessionsWithFiltersRequest searchFilters) {
        SuccessApiResponse<SearchApiResponse<AuthorizationSessionResponse>> result = this.httpClient.find(searchFilters);
        return SearchResult.withItemsAndCount((List)((SearchApiResponse)result.getResult()).getItems(), (Long)((SearchApiResponse)result.getResult()).getCount());
    }

    public Optional<AuthorizationSessionResponse> findById(String id) {
        return Optional.of((AuthorizationSessionResponse)this.httpClient.findById(id).getResult());
    }

    public void disable(String id) {
        this.httpClient.disableById(id);
    }

    public void disableByPhone(DisableByPhoneRequest command) {
        this.httpClient.disableByPhoneNumber(command);
    }

    public void disableByEmail(DisableByEmailRequest command) {
        this.httpClient.disableByEmail(command);
    }

    public void disableByIp(DisableByIpRequest command) {
        this.httpClient.disableByIp(command);
    }

    public void disableByDeviceId(DisableByDeviceIdRequest command) {
        this.httpClient.disableByDeviceId(command);
    }

    public void disableByUsername(DisableByUsernameRequest command) {
        this.httpClient.disableByUsername(command);
    }

    public FeignHTTPAuthorizationSessionFacade(FeignAuthorizationSessionClient httpClient) {
        this.httpClient = httpClient;
    }
}

