/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session.FeignAuthorizationSessionServiceErrorDecoder;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByDeviceIdRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByIpRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByPhoneRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.DisableByUsernameRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.SearchAuthorizationSessionsWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.resources.AuthSessionResource;

@FeignClient(name="feign-auth-session-service", url="${foodtechlab.infrastructure.microservice.auth-service.url}", configuration={FeignAuthorizationSessionServiceErrorDecoder.class})
public interface FeignAuthorizationSessionClient
extends AuthSessionResource {
    @GetMapping(value={"/api/v1/auth-sessions"})
    public SuccessApiResponse<SearchApiResponse<AuthorizationSessionResponse>> find(@SpringQueryMap SearchAuthorizationSessionsWithFiltersRequest var1);

    @GetMapping(value={"/api/v1/auth-sessions/{id}"})
    public SuccessApiResponse<AuthorizationSessionResponse> findById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/auth-sessions/{id}/disable"})
    public OkApiResponse disableById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-phone"})
    public OkApiResponse disableByPhoneNumber(@RequestBody DisableByPhoneRequest var1);

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-username"})
    public OkApiResponse disableByUsername(@RequestBody DisableByUsernameRequest var1);

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-email"})
    public OkApiResponse disableByEmail(@RequestBody DisableByEmailRequest var1);

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-ipv4"})
    public OkApiResponse disableByIp(@RequestBody DisableByIpRequest var1);

    @PostMapping(value={"/api/v1/auth-sessions/disable-by-device-id"})
    public OkApiResponse disableByDeviceId(@RequestBody DisableByDeviceIdRequest var1);
}

