package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session.impl;

import com.rcore.domain.commons.port.dto.SearchResult;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.authorizationSession.AuthorizationSessionServiceFacade;
import ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session.FeignAuthorizationSessionClient;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.requests.*;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class FeignHTTPAuthorizationSessionFacade implements AuthorizationSessionServiceFacade {

    private final FeignAuthorizationSessionClient httpClient;

    @Override
    public SearchResult<AuthorizationSessionResponse> find(SearchAuthorizationSessionsWithFiltersRequest searchFilters) {
        var result = httpClient.find(searchFilters);
        return SearchResult.withItemsAndCount(
                result.getResult().getItems(),
                result.getResult().getCount()
        );
    }

    @Override
    public Optional<AuthorizationSessionResponse> findById(String id) {
        return Optional.of(httpClient.findById(id).getResult());
    }

    @Override
    public void disable(String id) {
        httpClient.disableById(id);
    }

    @Override
    public void disableByPhone(DisableByPhoneRequest command) {
        httpClient.disableByPhoneNumber(command);
    }

    @Override
    public void disableByEmail(DisableByEmailRequest command) {
        httpClient.disableByEmail(command);
    }

    @Override
    public void disableByIp(DisableByIpRequest command) {
        httpClient.disableByIp(command);
    }

    @Override
    public void disableByDeviceId(DisableByDeviceIdRequest command) {
        httpClient.disableByDeviceId(command);
    }

    @Override
    public void disableByUsername(DisableByUsernameRequest command) {
        httpClient.disableByUsername(command);
    }
}
